#include <stdint.h>

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

void fn1 ( int32_t array1[ 4 ] );

void fn2 ( int32_t array2[ ] );

void fn ( int32_t *ptr )
{
  int32_t arr3[ 3 ] = { 1, 2, 3 };
  int32_t arr4[ 4 ] = { 0, 1, 2, 3 };

  /* Compliant - size of array matches the prototype        */
  fn1 ( arr4 );

  /* Non-compliant - size of array does not match prototype */
  fn1 ( arr3 );

  /* Compliant only if ptr points to at least 4 elements    */
  fn1 ( ptr );

  /* Compliant                                              */
  fn2 ( arr4 );

  /* Compliant                                              */
  fn2 ( ptr );
}

/* ------------------ Example code from MISRA C:2012 end ------------------ */

void fn1PtrTest ( void )
{
  int32_t arr3[ 3 ] = { 1, 2, 3 };
  int32_t arr4[ 4 ] = { 0, 1, 2, 3 };

  /* Non-compliant */
  fn ( arr3 );

  /* Compliant */
  fn ( arr4 );
}
